<?xml version="1.0" encoding="UTF-8"?>
<!--
    Marc de Graauw
    Version 0.1
    26 March 2008
    
    The stylesheet signedData.xsl generates a signedData block from any AORTA HL7 document
    Other HL7 docs should work if trigger events are provided 
-->
<xsl:stylesheet xmlns="http://www.aortarelease.nl/805/" xmlns:hl7="urn:hl7-org:v3"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <!-- No XML declaration -->
    <xsl:output method="xml" omit-xml-declaration="yes" encoding="UTF-8"/>
    <xsl:strip-space elements="*"/>
    <!-- Getting the root of HL7: name is different for each interaction, and should work with SOAP as well,
        so get the parent in interactionId -->
    <xsl:template match="//*[hl7:interactionId]">
        <!-- Use explicit xsl:element generators to control namespaces declarations -->
        <xsl:element name="signedData" namespace="http://www.aortarelease.nl/805/"
            xmlns:wsu="http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd">
            <xsl:attribute name="wsu:Id">token_<xsl:value-of select="hl7:id/@root"/>_<xsl:value-of select="hl7:id/@extension"/></xsl:attribute>
            <xsl:element name="authenticationData" namespace="http://www.aortarelease.nl/805/">
                <xsl:element name="messageId" namespace="http://www.aortarelease.nl/805/">
                    <xsl:element name="root" namespace="http://www.aortarelease.nl/805/">
                        <xsl:value-of select="hl7:id/@root"/>
                    </xsl:element>
                    <xsl:element name="extension" namespace="http://www.aortarelease.nl/805/">
                        <xsl:value-of select="hl7:id/@extension"/>
                    </xsl:element>
                </xsl:element>
                <xsl:element name="notBefore" namespace="http://www.aortarelease.nl/805/">
                    <!-- assume precision of creationTime is in minutes at least, add seconds -->
                    <xsl:value-of select="substring(concat(hl7:creationTime/@value,'00'), 1,14)"
                    />
                </xsl:element>
                <xsl:element name="notAfter" namespace="http://www.aortarelease.nl/805/">
                    <xsl:apply-templates select="hl7:creationTime/@value"/>
                </xsl:element>
                <xsl:element name="addressedParty" namespace="http://www.aortarelease.nl/805/">
                    <xsl:element name="root" namespace="http://www.aortarelease.nl/805/"
                        >2.16.840.1.113883.2.4.6.6</xsl:element>
                    <xsl:element name="extension" namespace="http://www.aortarelease.nl/805/"
                    >1</xsl:element>
                </xsl:element>
            </xsl:element>
            <xsl:element name="coSignedData" namespace="http://www.aortarelease.nl/805/">
                <xsl:element name="triggerEventId" namespace="http://www.aortarelease.nl/805/">
                    <!-- add new trigger events when necessary -->
                    <xsl:choose>
                        <xsl:when test="//hl7:COMT_IN113113NL">COMT_TE113113</xsl:when>
                        <xsl:when test="//hl7:COMT_IN118118">COMT_TE118118</xsl:when>
                        <xsl:when test="//hl7:QUPC_IN990001NL">QUPC_TE990001NL</xsl:when>
                        <xsl:when test="//hl7:REPC_IN990003NL">REPC_TE990003NL</xsl:when>
                        <xsl:when test="//hl7:QURX_IN990011NL">QURX_TE990011NL</xsl:when>
                        <xsl:when test="//hl7:QURX_IN990001NL">QURX_TE990001NL</xsl:when>
                        <xsl:when test="//hl7:MFMT_IN002101">MFMT_TE002101</xsl:when>
                        <xsl:when test="//hl7:MFMT_IN002102">MFMT_TE002102</xsl:when>
                        <xsl:when test="//hl7:MFMT_IN002103">MFMT_TE002103</xsl:when>
                        <xsl:when test="//hl7:PORX_IN932000NL">PORX_TE990001NL</xsl:when>
                        <xsl:when test="//hl7:PORX_IN924000NL">PORX_TE990011NL</xsl:when>
                        <xsl:otherwise>Trigger Event niet ondersteund</xsl:otherwise>
                    </xsl:choose>
                </xsl:element>
                <xsl:element name="patientId" namespace="http://www.aortarelease.nl/805/">
                    <xsl:element name="root" namespace="http://www.aortarelease.nl/805/"
                        >2.16.840.1.113883.2.4.6.3</xsl:element>
                    <xsl:element name="extension" namespace="http://www.aortarelease.nl/805/">
                        <xsl:value-of
                            select="//node()[@root='2.16.840.1.113883.2.4.6.3']/@extension[1]"
                        />
                    </xsl:element>
                </xsl:element>
            </xsl:element>
        </xsl:element>
    </xsl:template>

    <xsl:template match="/*/hl7:creationTime/@value">
        <!-- set expiry to start plus 4:59, or to the end of the hour if value goes past whole hour-->
        <xsl:value-of
            select="concat(substring(. ,1,10), substring(. ,11,2) + 4 - (((substring(. ,11,2) + 4) > 59) * ((substring(. ,11,2) + 4) - 59)), '59')"
        />
    </xsl:template>
</xsl:stylesheet>
